/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CAccelerator.h,v 1.2 1999/09/17 04:20:46 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CAccelerator_h	// [
#define Included_CAccelerator_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CAccelerator

class CAccelerator
{
	NOT_COPYABLE(CAccelerator)

public:
	CAccelerator();
	CAccelerator(HACCEL accel);
	CAccelerator(HINSTANCE instance, const char *tableName);
	virtual ~CAccelerator();

	CAccelerator&	operator=(HACCEL accel);

	operator HACCEL() const {return mAccel;}
	HACCEL	Get() const {return mAccel;}

	PGPBoolean	IsAttached() const;
	PGPInt32	Translate(HWND window, MSG& message) const;

	void	Load(HINSTANCE instance, const char *tableName);
	void	Attach(HACCEL mAccel);
	void	Clear();

private:
	HACCEL	mAccel;
};


// Class CAccelerator member functions

inline 
CAccelerator::CAccelerator() : mAccel(NULL)
{
}

inline 
CAccelerator::CAccelerator(HACCEL accel) : mAccel(NULL)
{
	Attach(accel);
}

inline 
CAccelerator::CAccelerator(HINSTANCE instance, const char *tableName) : 
	mAccel(NULL)
{
	Load(instance, tableName);
}

inline 
CAccelerator::~CAccelerator()
{
	try
	{
		Clear();
	}
	catch (CComboError&) { }
}

inline 
CAccelerator& 
CAccelerator::operator=(HACCEL accel)
{
	Attach(accel);
	return *this;
}

inline 
PGPBoolean 
CAccelerator::IsAttached() const
{
	return IsntNull(mAccel);
}

inline 
PGPInt32 
CAccelerator::Translate(HWND window, MSG& message) const
{
	return TranslateAccelerator(window, mAccel, &message);
}

inline 
void 
CAccelerator::Load(HINSTANCE instance, const char *tableName)
{
	mAccel = LoadAccelerators(instance, tableName);

	if (IsNull(mAccel))
		THROW_ERRORS(kPGPError_Win32ResourceOpFailed, GetLastError());
}

inline 
void 
CAccelerator::Attach(HACCEL accel)
{
	if (mAccel == accel)
		return;

	Clear();
	mAccel = accel;
}

inline 
void 
CAccelerator::Clear()
{
	mAccel = NULL;
}

_PGP_END

#endif	// ] Included_CAccelerator_h
